/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data;

import io.gitlab.jfronny.commons.data.NumberLimits;
import java.math.BigDecimal;
import java.util.Objects;

public class LazilyParsedNumber
extends Number {
    private final String value;

    public LazilyParsedNumber(String value) {
        this.value = value;
    }

    private BigDecimal asBigDecimal() {
        BigDecimal decimal = NumberLimits.parseBigDecimal(this.value);
        if (Math.abs((long)decimal.scale()) >= 10000L) {
            throw new NumberFormatException("Number has unsupported scale: " + this.value);
        }
        return decimal;
    }

    @Override
    public int intValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            try {
                return (int)Long.parseLong(this.value);
            }
            catch (NumberFormatException nfe) {
                return this.asBigDecimal().intValue();
            }
        }
    }

    @Override
    public long longValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            return this.asBigDecimal().longValue();
        }
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.value);
    }

    public String toString() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof LazilyParsedNumber)) return false;
        LazilyParsedNumber that = (LazilyParsedNumber)o;
        if (!Objects.equals(this.value, that.value)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

